# AR Maintenance and Inspection Assistant - Frontend

This repository contains the Unity frontend for an Augmented Reality application aimed at assisting with machine maintenance and inspection. The project recognises physical markers placed on machinery and shows live data fetched from a back‑end service. It is built with **Unity** and **AR Foundation** and relies on Server‑Sent Events (SSE) for real‑time updates.

## Project Structure

```
Assets/
├── Modules/                # Core functionality
│   ├── DataRetrieval/      # SSE and HTTP utilities
│   └── MachineRecognition/ # AR image tracking and panel display
├── Scenes/                 # Unity scenes
Packages/                   # Package manifest
ProjectSettings/            # Unity project settings
```

### Modules

- **DataRetrieval** – Implements SSE clients and models used to receive real‑time data. The `SSEManager` is a singleton that manages SSE connections per URL and exposes helper methods for starting and stopping clients.  
- **MachineRecognition** – Provides image‑tracking logic. `ImageTrackingManager` spawns prefabs when reference images are detected and `TrackedImageController` attaches a `PanelManager` to each prefab for visualising incoming data.

## Key Components

- **SSEManager** – Ensures there is only one SSE client for a given endpoint and can start/stop clients.
- **SSEClient** – Manages the connection to the SSE endpoint and forwards messages to the event bus.
- **PanelManager** – Subscribes to SSE messages and updates a `TextMeshPro` display with sensor or fuzzy logic data.
- **ImageTrackingManager** – Listens for AR image tracking events, instantiates prefabs and notifies their controllers.
- **TrackedImageController** – Positions the prefab on the tracked image and connects the associated panel to the correct SSE URL.

## Data Model

Sensor readings and prioritised machine lists are represented with the simple classes defined in `SSEModels.cs`.

## Getting Started

1. Install **Unity 6000.0.46f1** (or newer).
2. Clone this repository and open the project with Unity Hub.
3. Open `Assets/Scenes/main.scene.unity` and enter Play mode to run the AR scene on a supported device.

When a tracked image is recognised, the corresponding prefab appears and begins streaming data from `https://api.arassistant.nl/mqtt/<imageId>/temperature` by default. Adjust the URLs in `TrackedImageController.SetPanelUrl` to point to your own endpoints if necessary.

## Customisation

- **Reference Images:** Add or remove images in `Assets/Modules/MachineRecognition/Markers` and rebuild the `referenceImageLibrary` asset to track new markers.
- **Data Endpoints:** Update the URL format in `TrackedImageController.cs` or modify `PanelManager` settings in prefabs to fetch different data.

---
This README provides a high‑level overview of the project. Refer to the code comments for detailed implementation notes.
